package gov.va.med.mhv.sm.admin.model;

import gov.va.med.mhv.sm.admin.model.AbstractBaseEntity;
import gov.va.med.mhv.sm.admin.enums.EmailNotificationEnum;
import gov.va.med.mhv.sm.admin.enums.MessageFilterEnum;
import gov.va.med.mhv.sm.admin.enums.ParticipantTypeEnum;
import gov.va.med.mhv.sm.admin.enums.UserStatusEnum;
import gov.va.med.mhv.sm.admin.enums.UserTypeEnum;

import java.util.Date;
import java.util.Locale;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;



@Entity
@Table(name = "SMS_USER")
@DiscriminatorValue("-1")
@DiscriminatorColumn(name="USER_TYPE", discriminatorType=DiscriminatorType.INTEGER)
@DynamicUpdate(value=true)
@SelectBeforeUpdate(value=true) 
public class SMUser extends AbstractBaseEntity implements MailParticipant {


	private static final long serialVersionUID = 1L;
	
	public SMUser(){
		status = UserStatusEnum.OPT_OUT;
		emailNotification = EmailNotificationEnum.NONE;
		messageFilter = MessageFilterEnum.ALL;
		this.active=true;
		this.createdDate = new Date();
		this.modifiedDate = new Date();
		Locale.setDefault(Locale.ENGLISH);
	}
	
	@Id
	@Column(name = "USER_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;

	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "CURRENT_LOGIN")
	@Temporal(TemporalType.TIMESTAMP)
	private Date currentLogin;
	
	@Column(name = "EMAIL_ADDRESS")
	private String email;
	
	@Column(name = "EMAIL_NOTIFICATION")
	@Enumerated(EnumType.ORDINAL)
	private EmailNotificationEnum emailNotification;
	
	@Column(name = "FIRST_NAME")
	private String firstName;
	
	@Column(name = "LAST_NAME")
	private String lastName;

	@Column(name = "LAST_LOGIN")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastLogin;

	@Column(name = "LAST_EMAIL_NOTIFICATION")
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastNotification;
	
	@Transient
	private Mailbox mailbox;
	
	@Column(name = "DEFAULT_MESSAGE_FILTER")
	@Enumerated(EnumType.ORDINAL)
	private MessageFilterEnum messageFilter;
	
	@Column(name = "MIDDLE_NAME")
	private String middleName;
	
	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Transient
	protected ParticipantTypeEnum participantType;
	
	@Column(name = "PHONE")
	private String phone;
	
	@Column(name = "PREFIX")
	private String prefix;
	
	@Column(name="Status")
	@Enumerated(EnumType.ORDINAL)
	protected UserStatusEnum status;

	@Column(name = "SUFFIX")
	private String suffix;
	
	@Column(name = "TITLE")
	private String title;
	
	@Column(name = "EXTERNAL_USER_NAME")
	private String userName;
	
	@Transient
	protected UserTypeEnum userType;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getCurrentLogin() {
		return currentLogin;
	}

	public void setCurrentLogin(Date currentLogin) {
		this.currentLogin = currentLogin;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public EmailNotificationEnum getEmailNotification() {
		return emailNotification;
	}

	public void setEmailNotification(EmailNotificationEnum emailNotification) {
		this.emailNotification = emailNotification;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Date getLastLogin() {
		return lastLogin;
	}

	public void setLastLogin(Date lastLogin) {
		this.lastLogin = lastLogin;
	}

	public Date getLastNotification() {
		return lastNotification;
	}

	public void setLastNotification(Date lastNotification) {
		this.lastNotification = lastNotification;
	}

	public MessageFilterEnum getMessageFilter() {
		return messageFilter;
	}

	public void setMessageFilter(MessageFilterEnum messageFilter) {
		this.messageFilter = messageFilter;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public ParticipantTypeEnum getParticipantType() {
		return participantType;
	}

	public void setParticipantType(ParticipantTypeEnum participantType) {
		this.participantType = participantType;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public UserStatusEnum getStatus() {
		return status;
	}

	public void setStatus(UserStatusEnum status) {
		this.status = status;
	}

	public String getSuffix() {
		return suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public UserTypeEnum getUserType() {
		return userType;
	}

	public void setUserType(UserTypeEnum userType) {
		this.userType = userType;
	}
	
	@Transient
	public String getName(){
		return lastName + ", " + firstName + " " + (middleName!=null?" "+middleName:"");
	}

	public Mailbox getMailbox() {
		return mailbox;
	}

	public void setMailbox(Mailbox mailbox) {
		this.mailbox = mailbox;
	}
	
}
